 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO_INSERCAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO_INSERCAO]
GO
GO
GO
--P_EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO_INSERCAO 1,2,0,'2015-06-01'
CREATE PROCEDURE P_EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO_INSERCAO (@CD_EMP INT, 
																	 @CD_FILIAL INT, 
																	 @CD_PROD_PAR INT=0, 
																	 @DT_PROC	DATETIME=NULL,
																	 @Debug		tinyint=0)
AS
if @Debug=1
begin
	PRINT	'****** Inicio - P_EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO_INSERCAO ******' + CONVERT(VARCHAR(8), GETDATE(), 108);
end

IF  OBJECT_ID('TEMPDB.DBO.#RsProdProcMovUlt') IS NOT NULL
	BEGIN
		 DROP TABLE #RsProdProcMovUlt
	END
	 
	CREATE TABLE #RsProdProcMovUlt(CD_EMP INT, CD_FILIAL INT,CD_PROD INT )  

/*************************************************************************************************/
	if @Debug=1
	begin
		PRINT	'Gravando ultimo proc custo Filial ' + CONVERT(VARCHAR(5), @CD_FILIAL) + 
					' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
	end

	DECLARE @NMTBL VARCHAR(100), @CMD VARCHAR(300);
	SET @NMTBL = 'EST_FECHA_PROC_MOV_PEND_TBL_PROC_' +CONVERT(VARCHAR,@CD_FILIAL);

	IF NOT OBJECT_ID(@NMTBL) IS NULL
	BEGIN 
		SET @CMD = 'INSERT INTO #RsProdProcMovUlt (CD_EMP, CD_FILIAL, CD_PROD)
					SELECT  DISTINCT CD_EMP, CD_FILIAL, CD_PROD
					FROM ' + @NMTBL + ' WHERE CD_EMP=1 '  
		SET @CMD = @CMD+ ' AND CD_FILIAL =' + convert(varchar,@CD_FILIAL) 
		
		IF NOT @DT_PROC  IS NULL
			SET @CMD = @CMD+ ' AND DT_PROC =''' + convert(varchar,@DT_PROC,112)  + ''''

		EXEC (@CMD);
	END 

	IF @CD_PROD_PAR > 0 
	BEGIN
		TRUNCATE TABLE #RsProdProcMovUlt;
		INSERT INTO #RsProdProcMovUlt(CD_EMP, CD_FILIAL, CD_PROD)
		SELECT @CD_EMP, @CD_FILIAL, @CD_PROD_PAR
	END

	
 	CREATE UNIQUE CLUSTERED INDEX #Ixd_#RsProdProcMovUlt ON #RsProdProcMovUlt (CD_PROD,CD_FILIAL,CD_EMP); 
/*************************************************************************************************/
	if @Debug=1
	begin
		PRINT	'Alterando ultimo proc custo (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
	end
		
    UPDATE
		u
	SET 
		u.DT_PROC=dbo.F_DT_ULT_PROC_EST_FECHA_PROC_MOV(p.CD_EMP,p.CD_FILIAL,p.CD_PROD,@DT_PROC),
		u.DT_CAD=GETDATE()
	FROM
		EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO u 
		INNER JOIN #RsProdProcMovUlt p ON
		u.CD_EMP = p.CD_EMP AND
		u.CD_FILIAL = p.CD_FILIAL AND
		u.CD_PROD = p.CD_PROD 
	WHERE
		U.CD_EMP=@CD_EMP	
		AND U.CD_FILIAL=@CD_FILIAL;

	if @Debug=1
	begin
		PRINT	'Adicionando ultimo proc custo (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
	end

	INSERT INTO EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO (CD_EMP,CD_FILIAL,CD_PROD,DT_PROC,DT_CAD)
	SELECT 
		DISTINCT 
		p.CD_EMP,
		p.CD_FILIAL,
		p.CD_PROD,
		@DT_PROC,
		GETDATE()
	FROM
		#RsProdProcMovUlt p 
		LEFT OUTER JOIN EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO u ON
		p.CD_EMP = u.CD_EMP AND
		p.CD_FILIAL = u.CD_FILIAL AND
		p.CD_PROD = u.CD_PROD 

		INNER JOIN EST_PROD_CPL A ON
		p.CD_EMP = A.CD_EMP AND
		p.CD_FILIAL = A.CD_FILIAL AND
		p.CD_PROD = A.CD_PROD 
	WHERE
		u.CD_PROD IS NULL 	
		AND A.CD_EMP=@CD_EMP	
		AND A.CD_FILIAL=@CD_FILIAL;
	if @Debug=1
	begin
		PRINT	'fim ultimo proc custo (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
		PRINT	'****** Fim - P_EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO_INSERCAO ******' + CONVERT(VARCHAR(8), GETDATE(), 108);
	end
